function test_suite = testCumprod %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertTrue(isempty(cumprod(x)))

function testDefault
x = polysym;
assertTrue(iszero(cumprod(x)))

function testRealScalar
x = polysym(pi);
assertEqual(cumprod(x),x);

function testCharScalar
x = polysym('x');
assertEqual(cumprod(x),x);

function testArrayOfOnes
x = polysym(ones(3,1));
assertEqual(cumprod(x),x)

function testRealVectorWithUnity
x = polysym(1:3);
assertEqual(cumprod(x),[x(1) x(2) x(2)*x(3)]);


function testCharColumnVector
x = polysym('x',[3 1]);
assertEqual(cumprod(x),[x(1); x(1)*x(2); x(1)*x(2)*x(3)]);

function testMatrix
x = polysym('x',2);
assertEqual(cumprod(x),[x(1,:); x(1,:).*x(2,:)]);

function testMatrixSecondDim
x = polysym('x',2);
assertEqual(cumprod(x,2),[x(:,1) x(:,1).*x(:,2)]);

function testDimTooLarge
polysyms('x')
f = @() x.cumprod(3);
assertExceptionThrown(f,'MATLAB:polysym:diff:notLess')

function testDimTooSmall
polysyms('x')
f = @() x.cumprod(0);
assertExceptionThrown(f,'MATLAB:polysym:diff:notGreater')
